/**
 * Script para Comunicacin e Imagen Institucional
 * Manejo de tabs y funcionalidad interactiva
 */

document.addEventListener('DOMContentLoaded', function() {

    // ===================================
    // MANEJO DE TABS
    // ===================================
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const tabId = this.getAttribute('data-tab');

            // Remover clase active de todos los botones y contenidos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));

            // Agregar clase active al botn clickeado
            this.classList.add('active');

            // Mostrar el contenido correspondiente
            const activeContent = document.getElementById(tabId);
            if (activeContent) {
                activeContent.classList.add('active');
            }

            // Scroll suave hacia arriba del contenido
            window.scrollTo({
                top: document.querySelector('.comunicacion-main').offsetTop - 100,
                behavior: 'smooth'
            });
        });
    });

    // ===================================
    // NAVEGACIN CON TECLADO
    // ===================================
    tabButtons.forEach((button, index) => {
        button.addEventListener('keydown', function(e) {
            let targetButton;

            if (e.key === 'ArrowDown') {
                e.preventDefault();
                targetButton = tabButtons[index + 1] || tabButtons[0];
            } else if (e.key === 'ArrowUp') {
                e.preventDefault();
                targetButton = tabButtons[index - 1] || tabButtons[tabButtons.length - 1];
            }

            if (targetButton) {
                targetButton.focus();
                targetButton.click();
            }
        });
    });

    // ===================================
    // ACTUALIZAR ARIA ATTRIBUTES
    // ===================================
    function updateAriaAttributes() {
        tabButtons.forEach(button => {
            const isActive = button.classList.contains('active');
            button.setAttribute('aria-selected', isActive);

            const tabId = button.getAttribute('data-tab');
            const tabPanel = document.getElementById(tabId);
            if (tabPanel) {
                tabPanel.setAttribute('aria-hidden', !isActive);
            }
        });
    }

    // Actualizar atributos ARIA al cambiar de tab
    tabButtons.forEach(button => {
        button.addEventListener('click', updateAriaAttributes);
    });

    // Inicializar atributos ARIA
    updateAriaAttributes();

    console.log('Script de Comunicacin e Imagen Institucional cargado correctamente');
});
